<?php
include '../includes/db.php';

$message = '';
$video = null;

// URL থেকে আইডি নিন
if (!isset($_GET['id'])) {
    header("Location: manage_videos.php");
    exit();
}
$id = intval($_GET['id']);

// যদি ফর্ম সাবমিট করা হয় (POST request)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $conn->real_escape_string($_POST['title']);
    $category_id = intval($_POST['category_id']);
    $id_to_update = intval($_POST['id']);

    $sql_update = "UPDATE videos SET title = ?, category_id = ? WHERE id = ?";
    $stmt = $conn->prepare($sql_update);
    $stmt->bind_param("sii", $title, $category_id, $id_to_update);

    if ($stmt->execute()) {
        $message = "<div class='alert alert-success'>ভিডিওর তথ্য সফলভাবে আপডেট হয়েছে।</div>";
    } else {
        $message = "<div class='alert alert-danger'>আপডেট করতে সমস্যা হয়েছে: " . $conn->error . "</div>";
    }
}

// ডেটাবেস থেকে এডিট করার জন্য ভিডিওর বর্তমান তথ্য নিন
$sql_select = "SELECT * FROM videos WHERE id = ?";
$stmt_select = $conn->prepare($sql_select);
$stmt_select->bind_param("i", $id);
$stmt_select->execute();
$result = $stmt_select->get_result();

if ($result->num_rows > 0) {
    $video = $result->fetch_assoc();
} else {
    // যদি ভিডিও খুঁজে না পাওয়া যায়
    header("Location: manage_videos.php");
    exit();
}
?>

<?php include '../includes/header.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<h1 class="mt-4">ভিডিও এডিট করুন</h1>

<?php echo $message; ?>

<div class="card my-4">
    <div class="card-header">
        ভিডিওর তথ্য পরিবর্তন করুন
    </div>
    <div class="card-body">
        <?php if ($video): ?>
        <form action="edit_video.php?id=<?php echo $id; ?>" method="post">
            <input type="hidden" name="id" value="<?php echo $video['id']; ?>">
            
            <div class="form-group">
                <label for="title">ভিডিওর টাইটেল</label>
                <input type="text" name="title" id="title" class="form-control" value="<?php echo htmlspecialchars($video['title']); ?>" required>
            </div>
            
            <div class="form-group">
                <label for="category_id">ক্যাটাগরি</label>
                <select name="category_id" id="category_id" class="form-control" required>
                    <?php
                    $cat_sql = "SELECT id, name FROM categories ORDER BY name ASC";
                    $cat_result = $conn->query($cat_sql);
                    if ($cat_result->num_rows > 0) {
                        while($cat_row = $cat_result->fetch_assoc()) {
                            // বর্তমান ক্যাটাগরিকে ডিফল্ট হিসেবে সিলেক্ট করে রাখুন
                            $selected = ($cat_row['id'] == $video['category_id']) ? 'selected' : '';
                            echo "<option value='" . $cat_row['id'] . "' " . $selected . ">" . htmlspecialchars($cat_row['name']) . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>

            <div class="form-group">
                <label>বর্তমান থাম্বনেইল</label><br>
                <img src="../<?php echo htmlspecialchars($video['thumbnail_path']); ?>" alt="Thumbnail" style="width: 200px; height: auto;">
            </div>
            
            <button type="submit" class="btn btn-primary">আপডেট করুন</button>
            <a href="manage_videos.php" class="btn btn-secondary">ফিরে যান</a>
        </form>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
<?php $conn->close(); ?>